#-------------------------------------------------
#
# Project created by QtCreator 2021-09-23T21:33:59
#
#-------------------------------------------------

PROGNAME = Htlc
VERSION = 0.0.2
YEAR = 2024

QT       += core
QT       -= gui

TARGET = htlc
CONFIG   += console
CONFIG   -= app_bundle

QMAKE_CXXFLAGS += -std=c++11

TEMPLATE = app


SOURCES += main.cpp \
  htlc.cpp

HEADERS += \
    htlc.h

DISTFILES += \
  CHANGES \
  INSTALL \
  htlc.texi

# Define macros for use in the source text
DEFINES += "PROGNAME=\"\\\"$$PROGNAME\\\"\"" \
           "VERSION=\"\\\"$$VERSION\\\"\"" \
           "YEAR=\"\\\"$$YEAR\\\"\""

# Generate documentation

PRE_TARGETDEPS += htlc.pdf htlc.html htlc.info

QMAKE_EXTRA_TARGETS += doc_pdf doc_html doc_info doc_flags

doc_pdf.target   = htlc.pdf
doc_pdf.commands = texi2pdf -I $$OUT_PWD $$PWD/htlc.texi
doc_pdf.depends  = $$PWD/htlc.texi flags.texi

doc_html.target   = htlc.html
doc_html.commands = texi2html -I $$OUT_PWD $$PWD/htlc.texi
doc_html.depends  = $$PWD/htlc.texi flags.texi

doc_info.target   = htlc.info
doc_info.commands = texi2any -I $$OUT_PWD $$PWD/htlc.texi
doc_info.depends  = $$PWD/htlc.texi flags.texi

doc_flags.target   = flags.texi
doc_flags.commands = printf \"@set VERSION $$VERSION\n\" > flags.texi; \
                     printf \"@set UPDATED \" >> flags.texi; date +'%d.%m.%Y' >> flags.texi; printf \"\n\" >> flags.texi; \
                     printf \"@set PROGNAME $$PROGNAME\n\" >> flags.texi; \
                     printf \"@set CMDNAME $$TARGET\n\" >> flags.texi; \
                     printf \"@set YEAR $$YEAR\n\" >> flags.texi;
doc_flags.depends  = $$PWD/htlc.texi
